﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;

namespace WPF.PresentationLayer
{
    public static class ListExtension
    {
        public static ObservableCollection<T> ToObservableCollection<T>(this IEnumerable<T> source)
        {
            if (source == null) throw new ArgumentNullException("source");

            return new ObservableCollection<T>(source);
        }

        public static void ReplaceItem<T>(this IList<T> collection, T exitingItem, T newItem)
        {
            if (collection == null) throw new ArgumentNullException("collection");

            int exitingItemIdx = collection.IndexOf(exitingItem);

            if (exitingItemIdx >= 0)
            {
                collection[exitingItemIdx] = newItem;
            }
        }

        public static void AddRange<T>(this IList<T> collection, IEnumerable<T> range)
        {
            foreach (T item in range)
            {
                collection.Add(item);
            }
        }

        public static ArrayList ToArrayList<T>(this IEnumerable<T> input)
        {
            var col = input as ICollection;
            if (col != null)
            {
                return new ArrayList(col);
            }

            var res = new ArrayList();
            foreach (var item in input)
            {
                res.Add(item);
            }
            return res;
        }
        //public static RangeEnabledObservableCollection<T> ToRangeEnabledObservableCollection<T>(this IEnumerable<T> source)
        //{
        //    if (source == null) throw new ArgumentNullException("source");

        //    return new RangeEnabledObservableCollection<T>(source);
        //}
    }
}
